Summary: Adobe AIR
Name: adobeair
Version:2.6.0
Release:19170 
License: Commercial
Group: Applications
Source: adobeair
Requires: gtk2 >= 2.6.0, /usr/bin/env, /bin/uname, /bin/grep, /bin/cat, /bin/chmod, /bin/ln, /bin/ls, /bin/rm, /bin/sh, /bin/echo, /usr/bin/awk, /usr/lib/libxslt.so.1, /usr/lib/libxml2.so.2

URL: http://www.adobe.com
Vendor: Adobe Systems, Incorporated
Packager: Adobe Systems, Incorporated
AutoReqProv: no
Conflicts: adobeair1.0

%description
Adobe AIR 2

%define _use_internal_dependency_generator 0
%define __check_files %{nil}
%define _unpackaged_files_terminate_build  0
%define _missing_doc_files_terminate_build 0

%prep

%build

%install

%pre

CheckArchitecture()
{
	if [ "`uname -m`" = "x86_64" ]; then
		printf "\n Running 32-bit AIR on 64-bit systems has not been fully tested. However, 32-bit AIR is expected to run on 64-bit systems if they have the required 32-bit libraries and packages installed. \n The following links describe how to install or update AIR 2.6 on 64-bit versions of Ubuntu 9.10, Fedora Core 12 and OpenSuse 11.2. \n Installing Adobe AIR 2.6 on 64-bit Linux visit http://kb2.adobe.com/cps/521/cpsid_52132.html \n Updating to Adobe AIR 2.6 on 64-bit Linux visit http://kb2.adobe.com/cps/521/cpsid_52132.html\n"
	fi
	return 0
}

CheckKeyring()
{
	for i in /usr/lib/libgnome-keyring* /lib/libgnome-keyring* /usr/lib/libkwallet* /lib/libkwallet*; do
		if [ -f "$i" ]; then
			return 0
		fi
	done

	echo "Adobe AIR could not be installed. Either gnome-keyring or Kwallet must be installed prior to installing Adobe AIR." >&2
	return 1
}


CheckDependencies()
{
	CheckArchitecture && true
}


CheckDependencies || exit 1

exit 0

%post

## For first install "$1" gets 1, in case of upgrade request it gets 2

if which kde-config >/dev/null 2>&1; then
    :
else
    PATH="$PATH:/opt/kde3/bin:/opt/kde4/bin:/opt/kde/bin"
    export PATH
fi

if [ -z "$XDG_DATA_DIRS" ]; then
    XDG_DATA_DIRS="/usr/share/:/usr/local/share/"

    if xdg_data_dir=`kde-config --prefix 2>/dev/null`; then
        XDG_DATA_DIRS="${XDG_DATA_DIRS}:${xdg_data_dir}/share/"
    fi

    if [ -x /opt/gnome/bin/gnome-open ]; then
        XDG_DATA_DIRS="${XDG_DATA_DIRS}:/opt/gnome/share/"
    fi

    export XDG_DATA_DIRS
fi

if [ -n "$RPM_INSTALL_PREFIX" ]; then
    InstallDir="$RPM_INSTALL_PREFIX"
else
    InstallDir="/opt/Adobe AIR"
fi

version="1.0"
VersionDir="$InstallDir/Versions/$version"
ResourceDir="$VersionDir/Resources"
PATH="$ResourceDir/xdg-utils:$PATH"
XDG_UTILS_INSTALL_MODE="system"

export PATH
export XDG_UTILS_INSTALL_MODE


InstallIcons()
{
    icon_dir="$1"

    for icon_size in 16 22 24 32 48 64 128; do
        xdg-icon-resource install --noupdate --novendor --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/AdobeAIR.png"
        xdg-icon-resource install --noupdate --novendor --theme gnome --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/AdobeAIR.png"
        xdg-icon-resource install --noupdate --novendor --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png"
        xdg-icon-resource install --noupdate --novendor --theme gnome --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png"
        xdg-icon-resource install --noupdate --novendor --context mimetypes --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png" 'application-vnd.adobe.air-application-installer-package+zip'
        xdg-icon-resource install --noupdate --novendor --theme gnome --context mimetypes --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png" 'application-vnd.adobe.air-application-installer-package+zip'
    done

    xdg-icon-resource forceupdate
}


InstallMimeType()
{
    xdg-mime install --novendor "$ResourceDir/support/AdobeAIR.xml"
}


SetAsDefaultApplication()
{
    oldpwd="$PWD"

    cd "$ResourceDir/support"
    xdg-mime default AdobeAIR.desktop 'application/vnd.adobe.air-application-installer-package+zip'

    cd "$oldpwd"
}

InstallDesktopFile()
{
    priority="`echo 1.0 | tr -d .`"
    mkdir -p "/opt/Adobe/Flash Player/AddIns/airappinstaller"
    env PATH="/usr/sbin:$PATH" update-alternatives --install "/usr/bin/Adobe AIR Application Installer" "Adobe_AIR_Application_Installer" "$VersionDir/Adobe AIR Application Installer" ${priority} \
		--slave "/usr/share/applications/AdobeAIR.desktop" "AdobeAIR.desktop" "$ResourceDir/support/AdobeAIR.desktop" \
		--slave "/opt/Adobe/Flash Player/AddIns/airappinstaller/airappinstaller" "airappinstaller" "$VersionDir/Resources/airappinstaller" \
		--slave "/opt/Adobe/Flash Player/AddIns/airappinstaller/digest.s" "digest.s" "$VersionDir/Resources/digest.s"
}

InstallDesktopFileOld()
{
    rm -f /usr/share/applications/AdobeAIR.desktop "/usr/bin/Adobe AIR Application Installer"
    ln -s "$ResourceDir/support/AdobeAIR.desktop" /usr/share/applications/AdobeAIR.desktop
    ln -s "$VersionDir/Adobe AIR Application Installer" "/usr/bin/Adobe AIR Application Installer"
}


IsLatestVersion()
{
    sxsVersion="1.0"

    if [ "`ls -1Sr "$1" | head -1`" != "$sxsVersion" ]; then
        return 1
    fi

    return 0
}

CheckUpdateAlternatives()
{
    env PATH="$PATH:/sbin:/usr/sbin" which update-alternatives >/dev/null 2>&1
}

CheckUpdateAlternatives && InstallDesktopFile >/dev/null 2>&1

if __TAG_HANDLE_AIR__ "$InstallDir/Versions"; then
    InstallMimeType >/dev/null 2>&1
    SetAsDefaultApplication >/dev/null 2>&1
    InstallIcons "$ResourceDir/support/icons" >/dev/null 2>&1
    CheckUpdateAlternatives || InstallDesktopFile >/dev/null 2>&1
fi

MergeCertificates()
{
	if [ "$1" = "2" ]; then
		if [ -f "/etc/opt/Adobe/certificates/AIR/crypt/config.xml.rpmsave" ] ; then
			inputFile="/etc/opt/Adobe/certificates/AIR/crypt/config.xml.rpmsave"
		elif [ -f "/etc/opt/Adobe/certificates/crypt/config.xml.rpmsave" ] ; then
			inputFile="/etc/opt/Adobe/certificates/crypt/config.xml.rpmsave"
			cp -rf /etc/opt/Adobe/certificates/crypt/*.[0-9]* /etc/opt/Adobe/certificates/AIR/crypt/ &>/dev/null
		elif [ -f "/etc/opt/Adobe/certificates/crypt/config.xml" ] ; then
			inputFile="/etc/opt/Adobe/certificates/crypt/config.xml"
			cp -rf /etc/opt/Adobe/certificates/crypt/*.[0-9]* /etc/opt/Adobe/certificates/AIR/crypt/ &>/dev/null
		fi

		if [ -n "${inputFile}" ]
		then
			"$ResourceDir/aucm" -m -S "$inputFile" -D "/etc/opt/Adobe/certificates/AIR/crypt/config.xml"
			return $?
		fi
	fi
	return 0
}

# Nested checking calls, because it's possble that one of the child does not exist but
# we still need to make sure that all the parent nodes are updated if not links
if [ -h "/var/opt/Adobe AIR/Shared/Adobe/AIR/Updater/initialPingback" ]
then
	:
else
	chmod 666 "/var/opt/Adobe AIR/Shared/Adobe/AIR/Updater/initialPingback" 2>/dev/null
fi

if [ ! -h "/var/opt/Adobe AIR/Shared/Adobe/AIR/Updater/updatePingback" ]
then
	rm -f "/var/opt/Adobe AIR/Shared/Adobe/AIR/Updater/updatePingback" 2>/dev/null
fi

## For first install "$1" gets 1, in case of upgrade request it gets 2
exitStatus=0
MergeCertificates "$1"
exitStatus=$?

if [ "$exitStatus" = "0" ]
then
	rm -f "/etc/opt/Adobe/certificates/AIR/crypt/config.xml.rpmsave"
	rm -f "/etc/opt/Adobe/certificates/crypt/config.xml.rpmsave"
fi

exit $exitStatus

%preun

## Check if this runtime is the latest of all the installed
IsLatestVersion()
{
    sxsVersion="1.0"

    if [ "`ls -1Sr "$1" | head -1`" != "$sxsVersion" ]; then
        return 1
    fi

    return 0
}


if [ "$1" = "0" ]; then             ## last uninstall, in case of upgrade request it gets 1
    if [ -n "$RPM_INSTALL_PREFIX" ]; then
        InstallDir="$RPM_INSTALL_PREFIX"
    else
        InstallDir="/opt/Adobe AIR"
    fi

    version=1.0
    VersionDir="$InstallDir/Versions/$version"
    ResourceDir="$VersionDir/Resources"
    PATH="$ResourceDir/xdg-utils:$PATH"
    XDG_UTILS_INSTALL_MODE="system"

    if which kde-config >/dev/null 2>&1; then
        :
    else
        PATH="$PATH:/opt/kde3/bin:/opt/kde4/bin:/opt/kde/bin"
    fi

    if [ -z "$XDG_DATA_DIRS" ]; then
        XDG_DATA_DIRS="/usr/share/:/usr/local/share/"

        if xdg_data_dir=`kde-config --prefix 2>/dev/null`; then
            XDG_DATA_DIRS="${XDG_DATA_DIRS}:${xdg_data_dir}/share/"
        fi

        if [ -x /opt/gnome/bin/gnome-open ]; then
            XDG_DATA_DIRS="${XDG_DATA_DIRS}:/opt/gnome/share/"
        fi

        export XDG_DATA_DIRS
    fi

    export PATH
    export XDG_UTILS_INSTALL_MODE

    InstallIcons()
    {
        icon_dir="$1"
    
        for icon_size in 12 16 20 22 24 32 48 64 128; do
            xdg-icon-resource uninstall --noupdate --novendor --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/AdobeAIR.png"
            xdg-icon-resource uninstall --noupdate --novendor --theme gnome --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/AdobeAIR.png"
            xdg-icon-resource uninstall --noupdate --novendor --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png"
            xdg-icon-resource uninstall --noupdate --novendor --theme gnome --context apps --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png"
            xdg-icon-resource uninstall --noupdate --novendor --context mimetypes --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png" 'application-vnd.adobe.air-application-installer-package+zip'
            xdg-icon-resource uninstall --noupdate --novendor --theme gnome --context mimetypes --size $icon_size "$icon_dir/${icon_size}x${icon_size}/air.png" 'application-vnd.adobe.air-application-installer-package+zip'
        done
    
        xdg-icon-resource forceupdate
    }


    InstallMimeType()
    {
        xdg-mime uninstall --novendor "$ResourceDir/support/AdobeAIR.xml"
    }

    SetAsDefaultApplication()
    {
        oldpwd="$PWD"

        cd "$ResourceDir/support"
        xdg-mime unset AdobeAIR.desktop 'application/vnd.adobe.air-application-installer-package+zip'
        cd "$oldpwd"
    }

    CheckUpdateAlternatives()
    {
    	env PATH="$PATH:/sbin:/usr/sbin" which update-alternatives >/dev/null 2>&1
    }

    InstallDesktopFile()
    {
        env PATH="/usr/sbin:$PATH" update-alternatives --remove "Adobe_AIR_Application_Installer" "$VersionDir/Adobe AIR Application Installer"

	if env PATH="/usr/sbin:$PATH" update-alternatives --list; then
		:
	else
        	env PATH="/usr/sbin:$PATH" update-alternatives --remove-all "Adobe_AIR_Application_Installer"
	fi

        rmdir -p "/opt/Adobe/Flash Player/AddIns/airappinstaller"
    }

    InstallDesktopFileOld()
    {
    	rm -f /usr/share/applications/AdobeAIR.desktop "/usr/bin/Adobe AIR Application Installer"
    }

    CheckUpdateAlternatives && InstallDesktopFile >/dev/null 2>&1

    if IsLatestVersion "$InstallDir/Versions"; then
        InstallIcons "$ResourceDir/support/icons" >/dev/null 2>&1
        SetAsDefaultApplication >/dev/null 2>&1
        InstallMimeType >/dev/null 2>&1
        CheckUpdateAlternatives || InstallDesktopFileOld
    fi
fi

exit 0


%postun

%files
%defattr(-, root, root)
"/opt/Adobe AIR"
"/etc/opt/Adobe/certificates/AIR"
%attr(0755, root, root) "/var/opt/Adobe AIR"
%attr(1777, root, root) "/var/opt/Adobe AIR/Shared"
%attr(0755, root, root) "/var/opt/Adobe AIR/Shared/Adobe"
%attr(0755, root, root) "/var/opt/Adobe AIR/Shared/Adobe/AIR"
%attr(1777, root, root) "/var/opt/Adobe AIR/Shared/Adobe/AIR/Updater"
%config "/etc/opt/Adobe/certificates/AIR/crypt/config.xml"
%doc

%changelog

